/**
 * \file: errors.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: Secure Data Container
 * \brief : Architecture specific errors for imx6
 *
 * <b>SDC private header</b>
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 * \author: Philipp Hachtmann (phachtmann@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __ARCH_ERRORS_H__
#define __ARCH_ERRORS_H__

#include <sdc.h>

#define SDC_IMX6_OPEN_KEYMAN_DEVICENODE_FAILED  SDC_ARCHITECTURE_SPECIFIC_ERROR_01  /**< SDC_IMX6_OPEN_KEYMAN_DEVICENODE_FAILED - failed open the keyman device node */
#define SDC_IMX6_KEYMAN_DEVICENODE_IOCTL_FAILED SDC_ARCHITECTURE_SPECIFIC_ERROR_02  /**< SDC_IMX6_KEYMAN_DEVICENODE_IOCTL_FAILED - keyman ioctl failed for some unspecified reason */
#define SDC_IMX6_OPEN_CAAMEE_DEVICENODE_FAILED  SDC_ARCHITECTURE_SPECIFIC_ERROR_03  /**< SDC_IMX6_OPEN_CAAMEE_DEVICENODE_FAILED - failed open the caamee device node */
#define SDC_IMX6_CAAMEE_DEVICENODE_IOCTL_FAILED SDC_ARCHITECTURE_SPECIFIC_ERROR_04  /**< SDC_IMX6_CAAMEE_DEVICENODE_IOCTL_FAILED - caamee ioctl failed for some unspecified reason */
#define SDC_IMX6_INVALID_DEVICENODE             SDC_ARCHITECTURE_SPECIFIC_ERROR_05  /**< SDC_IMX6_INVALID_DEVICENODE - ioctl returned EBADF - device seems to be closed */
#define SDC_IMX6_PERMISSION_MISMATCH            SDC_ARCHITECTURE_SPECIFIC_ERROR_06 /**< SDC_IMX6_PERMISSION_MISMATCH - Unable to match sdc to caam permissions or vice versa */

/* format error of encapsulated key passed to khd when importing a wrapped key */
#define SDC_IMX6_ENCAP_INVALID                  SDC_ARCHITECTURE_SPECIFIC_ERROR_07 /**< SDC_IMX6_ENCAP_INVALID - Invalid key encapsulation */


#define ARCH_ERROR_STRINGS \
    [SDC_IMX6_OPEN_KEYMAN_DEVICENODE_FAILED] = "SDC_IMX6_OPEN_KEYMAN_DEVICENODE_FAILED - failed open the keyman device node", \
    [SDC_IMX6_KEYMAN_DEVICENODE_IOCTL_FAILED] = "SDC_IMX6_KEYMAN_DEVICENODE_IOCTL_FAILED - keyman ioctl failed for some unspecified reason", \
    [SDC_IMX6_OPEN_CAAMEE_DEVICENODE_FAILED]  = "SDC_IMX6_OPEN_CAAMEE_DEVICENODE_FAILED - failed open the caamee device node", \
    [SDC_IMX6_CAAMEE_DEVICENODE_IOCTL_FAILED] = "SDC_IMX6_CAAMEE_DEVICENODE_IOCTL_FAILED - caamee ioctl failed for some unspecified reason", \
    [SDC_IMX6_INVALID_DEVICENODE] = "SDC_IMX6_INVALID_DEVICENODE - ioctl returned EBADF - device seems to be closed", \
    [SDC_IMX6_PERMISSION_MISMATCH] = "SDC_IMX6_PERMISSION_MISMATCH - Unable to match sdc to caam permissions or vice versa", \
    [SDC_IMX6_ENCAP_INVALID] = "SDC_IMX6_ENCAP_INVALID - Invalid key encapsulation",

#endif
